<#ibiztemplate>
TARGET=PSAPPVIEWCTRL_TREEVIEW
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import lombok.Data;
import org.springframework.util.StringUtils;
import ${pub.getPKGCodeName()}.ibizutil.errors.BadRequestAlertException;
import org.springframework.validation.annotation.Validated;
import org.springframework.http.ResponseEntity;
import ${pub.getPKGCodeName()}.ibizutil.domain.ActionResult;
import ${pub.getPKGCodeName()}.ibizutil.domain.TreeNode;
import ${pub.getPKGCodeName()}.ibizutil.domain.TreeNodeFilter;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;

<#comment>定义实体服务</#comment>
<#if item.getPSDETreeNodes()??>
<#list item.getPSDETreeNodes() as node>
<#if node.getTreeNodeType() == 'DE' && node.getPSDataEntity()??>
<#if !P.exists("importService",node.getPSDataEntity().getId(),"")>
import ${pub.getPKGCodeName()}.${node.getPSDataEntity().getPSSystemModule().codeName?lower_case}.service.${node.getPSDataEntity().codeName}Service;
</#if>
</#if>
</#list>
</#if>

@RestController
@RequestMapping("/${app.getPKGCodeName()?lower_case}/ctrl/${item.codeName?lower_case}treeview")
public class ${app.getPKGCodeName()}${item.codeName}TreeViewController{

	/**
	 * 节点分隔符号
	 */
	public static final String TREENODE_SEPARATOR = ";";
<#if item.getPSDETreeNodes()??>
<#list item.getPSDETreeNodes() as node>
	public static final String TREENODE_${node.getNodeType()?upper_case} = "${srfjavastring(node.getNodeType())}";
</#list>
</#if>

<#comment>注入各实体服务</#comment>
<#if item.getPSDETreeNodes()??>
<#list item.getPSDETreeNodes() as node>
<#if node.getTreeNodeType() == 'DE' && node.getPSDataEntity()??>
<#if !P.exists("@Resource",node.getPSDataEntity().getId(),"")>
	@Autowired
	private ${node.getPSDataEntity().codeName}Service ${node.getPSDataEntity().codeName?lower_case}Service;

	protected ${node.getPSDataEntity().codeName}Service get${node.getPSDataEntity().codeName}Service(){
		return ${node.getPSDataEntity().codeName?lower_case}Service;
	}
</#if>
</#if>
</#list>
</#if>

<#if item.getRootPSDETreeNode()??>
	@GetMapping(value="getnodes")
	public ResponseEntity<List<TreeNode>> getNodes(@Validated String srfparentkey,String srfcat,String srfnodeid,String srfnodefilter){
			List<TreeNode> list = new ArrayList<TreeNode>();
			TreeNodeFilter filter = new TreeNodeFilter();
			if (!StringUtils.hasLength(srfnodeid) || srfnodeid.equals("#")) {
                <#if item.isRootVisible()>
				fill${srfclassname(item.getRootPSDETreeNode().getNodeType()?lower_case)}Nodes(filter,list);
				return ResponseEntity.ok().body(list);
				<#else>
				srfnodeid = TREENODE_${item.getRootPSDETreeNode().getNodeType()?upper_case};
				</#if>
			}
			String strTreeNodeId = srfnodeid;
			String strRealNodeId = "";
			boolean bRootSelect = false;
			String strNodeType = null;
			// String strRootSelectNode = this.getWebContext().getPostValue("srfnodeselect");
			String strRootSelectNode = "";// this.getWebContext().getPostValue("srfnodeselect");
			if (strTreeNodeId.equals(TREENODE_${item.getRootPSDETreeNode().getNodeType()?upper_case})) {
				strNodeType = TREENODE_${item.getRootPSDETreeNode().getNodeType()?upper_case};
				//treeNode = this.getTreeModel().getRootTreeNodeModel();
				//strRealNodeId = treeNodeFetchContext.getCatalog();
				//bRootSelect = this.getTreeModel().isEnableRootSelect();
			} else {
				int nPos = strTreeNodeId.indexOf(TREENODE_SEPARATOR);
				if (nPos == -1) {
					throw new BadRequestAlertException("树节点[%1$s]标识无效","","");
				}

				strNodeType = strTreeNodeId.substring(0, nPos);
				strRealNodeId = strTreeNodeId.substring(nPos + 1);
			}
			filter.setSrfParentKey(srfparentkey);
			filter.setSrfCat(srfcat);
			filter.setSrfNodeFilter(srfnodefilter);
			filter.setRealNodeId(strRealNodeId);
			filter.setSrfNodeId(srfnodeid);
			filter.setNodeType(strNodeType);
			/**
			 * 分解节点标识
			 */
			String[] nodeid = strRealNodeId.split(TREENODE_SEPARATOR);
			for (int i = 0; i < nodeid.length; i++) {
				switch(i){
				case 0:
					filter.setNodeId(nodeid[0]);
					break;
				case 1:
					filter.setNodeId2(nodeid[1]);
					break;
				case 2:
					filter.setNodeId3(nodeid[2]);
					break;
				case 3:
					filter.setNodeId4(nodeid[3]);
					break;
				default:
					break;
				}
			}
<#list item.getPSDETreeNodes() as node>
			if(strNodeType.equals(TREENODE_${node.getNodeType()?upper_case})){
				fill${srfclassname(node.getNodeType()?lower_case)}NodeChilds(filter,list);
				return ResponseEntity.ok().body(list);
			}
</#list>
				return ResponseEntity.ok().body(list);
	}
</#if>

<#if item.getPSDETreeNodes()??>
<#list item.getPSDETreeNodes() as node>
	/**
	* 填充 树视图节点[${node.getName()}]
	*/
	protected void fill${srfclassname(node.getNodeType()?lower_case)}Nodes(@Validated TreeNodeFilter filter,List<TreeNode> list) {
<#if node.getTreeNodeType() == 'STATIC'>
		TreeNode treeNode = new TreeNode();
		treeNode.setText("${srfjavastring(node.getName())}");
		treeNode.setSrfmajortext("${srfjavastring(node.getName())}");
		String strNodeId = "${srfjavastring(node.getNodeType())}";
		<#if node.getNodeValue()?? && node.getNodeValue()?length gt 0>
		treeNode.setSrfkey("${srfjavastring(node.getNodeValue())}");
		strNodeId += TREENODE_SEPARATOR;
		strNodeId += "${srfjavastring(node.getNodeValue())}";
		</#if>
		<#if node.isAppendPNodeId()>
		strNodeId += TREENODE_SEPARATOR;
		strNodeId += filter.getRealNodeId();
		</#if>
		treeNode.setId(strNodeId);
		<#if node.getPSSysImage()??>
		treeNode.setIconcls("${item.getPSSysImage().getCssClass()}");
		treeNode.setIcon("${item.getPSSysImage().getImagePath()}");
		</#if>
		<#if node.isEnableCheck()>
		treeNode.setEnablecheck(true);
		</#if>
		<#if node.isExpanded()>
		treeNode.setExpanded(true);
		<#else>
		treeNode.setExpanded(filter.isAutoExpand());
		</#if>
		<#if node.hasPSDETreeNodeRSs()>
		treeNode.setLeaf(false);
		</#if>
		list.add(treeNode);
</#if>
<#if node.getTreeNodeType() == 'DE' && node.getPSDataEntity()??>
<#assign filtername>${pub.getPKGCodeName()}.${node.getPSDataEntity().getPSSystemModule().codeName?lower_case}.service.dto.${node.getPSDataEntity().codeName}SearchFilter</#assign>
<#assign entityname>${pub.getPKGCodeName()}.${node.getPSDataEntity().getPSSystemModule().codeName?lower_case}.domain.${node.getPSDataEntity().codeName}</#assign>
		${filtername} searchFilter = new ${filtername}();
<#list item.getPSDETreeNodeRSs() as noders>
<#if noders.getChildPSDETreeNode().id == node.id && noders.getParentPSDER1N()??>
<#assign pickupfield=noders.getParentPSDER1N().getPSPickupDEField()>
		if(filter.getNodeType().equals(TREENODE_${noders.getParentPSDETreeNode().getNodeType()?upper_case})){
			//关系 [${noders.getParentPSDER1N().getName()}]条件
			searchFilter.setN_${pickupfield.getName()?lower_case}_eq(filter.getNodeId<#if noders.getParentValueLevel() gt 1>${noders.getParentValueLevel()?c}</#if>());
		}
</#if>
</#list>
		//searchFilter.setActiveData(filter);
		<#if node.getSortPSDEField()??>

		</#if>
		List<${entityname}> pageResult = this.get${node.getPSDataEntity().codeName}Service().list${node.getPSDEDataSet().getCodeName()}(searchFilter);
		for(${entityname} entity : pageResult) {
			TreeNode treeNode = new TreeNode();
			<#if node.getIdPSDEField()??>
			String strId = entity.get${node.getIdPSDEField().codeName?lower_case?cap_first}();
			<#else>
			String strId = entity.get${node.getPSDataEntity().getKeyPSDEField().codeName?lower_case?cap_first}();
			</#if>
			<#if node.getTextPSDEField()??>
			String strText = entity.get${node.getTextPSDEField().codeName?lower_case?cap_first}();
			<#else>
			String strText = entity.get${node.getPSDataEntity().getMajorPSDEField().codeName?lower_case?cap_first}();
			</#if>
			treeNode.setSrfkey(strId);
			treeNode.setText(strText);
			treeNode.setSrfmajortext(strText);
			String strNodeId = "${srfjavastring(node.getNodeType())}";
			strNodeId += TREENODE_SEPARATOR;
			strNodeId += strId;
			<#if node.isAppendPNodeId()>
			strNodeId += TREENODE_SEPARATOR;
			strNodeId += filter.getRealNodeId();
			</#if>
			treeNode.setId(strNodeId);
			<#if node.getPSSysImage()??>
			treeNode.setIconcls("${item.getPSSysImage().getCssClass()}");
			treeNode.setIcon("${item.getPSSysImage().getImagePath()}");
			</#if>
			<#if node.isEnableCheck()>
			treeNode.setEnablecheck(true);
			</#if>
			<#if node.isExpanded()>
			treeNode.setExpanded(true);
			<#else>
			treeNode.setExpanded(filter.isAutoExpand());
			</#if>
			<#if node.hasPSDETreeNodeRSs()>
			treeNode.setLeaf(false);
			</#if>
			list.add(treeNode);
		}
</#if>
	}

	/**
	* 填充 树视图节点[${node.getName()}]子节点
	*/
	protected void fill${srfclassname(node.getNodeType()?lower_case)}NodeChilds(@Validated TreeNodeFilter filter,List<TreeNode> list) {
<#if item.getPSDETreeNodeRSs()??>
<#list item.getPSDETreeNodeRSs() as noders>
<#if noders.getParentPSDETreeNode().id == node.id>
		//填充${noders.getChildPSDETreeNode().getName()}
		fill${srfclassname(noders.getChildPSDETreeNode().getNodeType()?lower_case)}Nodes(filter,list);
</#if>
</#list>
</#if>
	}

</#list>
</#if>
}
